const express = require('express');
const controllers = require('../Controller');
const authmiddleware = require('../middleware/authJwt');
const router = express.Router();

// const authmiddleware= require('../middleware/auth')


// User routes
// router.get('/getallusers',authmiddleware.authenticate("jwt",{session:false}), controllers.userController.getAllUsers);
router.post('/createUsers', controllers.userController.createUser);
router.post('/verifyotp', controllers.userController.verifyOtpAndCreateUser);
router.put('/updateRemider',authmiddleware.authenticate("jwt",{session:false}), controllers.userController.updateReminder);
router.post('/verifyotp', controllers.userController.verifyOtpAndCreateUser);
router.get('/GetRemider/:userId',authmiddleware.authenticate("jwt",{session:false}), controllers.userController.getReminder);
router.get('/getCredit',authmiddleware.authenticate("jwt",{session:false}), controllers.userController.GetCredit);
router.get('/getHistoryHtml/:vin/:id?',authmiddleware.authenticate("jwt",{session:false}), controllers.userController.HistoryHtml);
router.post('/getSeacrhHistory/:id',authmiddleware.authenticate("jwt",{session:false}), controllers.userController.GetUserHistory);
router.get('/getAllUserStats/:id/:month',authmiddleware.authenticate("jwt",{session:false}), controllers.userController.getAllUsersWithSearchCount);
router.get('/getAllUserwithMonth/id',authmiddleware.authenticate("jwt",{session:false}), controllers.userController.getAllUsersWithMonthlyStats);
router.post('/getplans',authmiddleware.authenticate("jwt",{session:false}), controllers.userController.updateUserAndCompanyData);
router.post('/login', controllers.userController.loginUser);
router.post('/verifyOtpLogin', controllers.userController.verifyOtp);
router.post('/forgotOTP', controllers.userController.sendResetOtp);
router.post('/ResetPassword', controllers.userController.verifyResetOtp);

module.exports = router;
