var express = require('express');
var router = express.Router();
var user = require('./users')
var HtmlData= require('./Htmldata')
var Admin= require('./Admin')
var Webhook = require('./Webhook')
var userplans= require('./userplans')
var  ProfileLogo = require('./ProfileLogo')
// const authmiddleware= require('../middleware/auth')
const controllers = require('../Controller/index');
const authmiddleware = require('../middleware/authJwt');
const CurrentBits= require('./CurrentBits') 
const AddToCart = require('./AddtoCart');
const Favorite= require('./Favorite')
const pricing= require('./pricing');
const Purchase = require('./Purchase')
const { session } = require('passport');

router.get('/', function(req, res, next) {
  res.render('index', { title: 'Express' });
});
router.use('/Purchase',Purchase)
router.use("/AddToCart",authmiddleware.authenticate("jwt",{session:false}),AddToCart)
router.use("/favorites",authmiddleware.authenticate("jwt",{session:false}),Favorite)
router.use("/Bits",CurrentBits)
router.use("/user",user)
router.use("/Webhook",Webhook)
router.use("/pricing",authmiddleware.authenticate("jwt",{session:false}),pricing)
router.use("/ProfileLogo",authmiddleware.authenticate("jwt",{session:false}),ProfileLogo)
router.use('/userplan',userplans)
router.use("/HtmlData",authmiddleware.authenticate("jwt",{session:false}), HtmlData); 
router.get("/css",  controllers.CssData.getCss);
router.get("/image/:key",  controllers.CssData.getImage);
router.get('/test',authmiddleware.authenticate("jwt",{session:false}),(req,res)=>{
  console.log("Req",req.authorization);
  res.send("ok")

})
router.use("/admin",authmiddleware.authenticate("jwt",{session:false}),Admin)

module.exports = router;
