const express = require('express');
const controllers = require('../Controller');
const router = express.Router();
const multer = require('multer');
const upload = multer({ storage: multer.memoryStorage() }); 
const authmiddleware = require('../middleware/authJwt');




// User routes
router.post('/add',authmiddleware.authenticate('jwt',{session:false}), controllers.Purchase.createPurchase);
router.post('/get',authmiddleware.authenticate('jwt',{session:false}), controllers.Purchase.getPurchasesByAdminId);
router.put('/update',authmiddleware.authenticate('jwt',{session:false}), controllers.Purchase.UpdatePurchase);
router.get('/searchHistory', controllers.Purchase.getSearchHistory);
router.get('/CurrentBid',authmiddleware.authenticate('jwt',{session:false}), controllers.Purchase.getCurrentBid);
router.post('/upload',authmiddleware.authenticate('jwt',{session:false}),upload.single('image'),controllers.Purchase.uploadImages)

router.patch('/update-details',authmiddleware.authenticate('jwt',{session:false}),controllers.Purchase.UpdatePurchaseDetails)
router.post('/update_purhchases',authmiddleware.authenticate('jwt',{session:false}),controllers.Purchase.updatePurchaseFields)

router.post('/purchase-totals',authmiddleware.authenticate('jwt',{session:false}), controllers.Purchase.getProfitSummary);
router.post('/updateCost',authmiddleware.authenticate('jwt',{session:false}), controllers.Purchase.updatePurchaseCosts);


module.exports = router;






// Upload & update existing post


module.exports = router;
