const express = require('express');
const controllers = require('../Controller/index');
const router = express.Router();
const authmiddleware= require('../middleware/auth')

const rateLimit = require('express-rate-limit');
const apiLimiter = rateLimit({
  windowMs: 1 * 60 * 1000, // 15 minutes
  max: 3, // Limit each IP to 1 request per `windowMs`
  message: "Too many requests, please try again later.",
});
router.use(apiLimiter)
// User routes
router.get(
    "/getHtmlPage/:vin",
    controllers.HtmlDataController.fetchAndSaveHtml
  );
  

// router.get("/js",  controllers.jsData.getJs);

// router.get("/getjs/:vin",  controllers.HtmlDataController.getJsByVin);
router.post("/token", controllers.HtmlDataController.saveToken); 


module.exports = router;
