const express = require('express');
const controllers = require('../Controller');
const router = express.Router();

const authmiddleware= require('../middleware/auth')



// User routes
router.get('/getallusers/:id', controllers.Admin.getAllUsers);
router.post('/generateRefCode', controllers.Admin.generateRefcode);
router.get('/getRefCode', controllers.Admin.getPromoCode);
router.put('/updatepromo', controllers.Admin.UpdatePromoCode);
router.get('/getallAdmin', controllers.Admin.getAlladmin);
router.put('/updateUser/:id', controllers.Admin.updateUser);
router.delete('/deleteUser/:id', controllers.Admin.deleteUser);
router.get('/online_users', controllers.Admin.getOnlineUsers);
router.put('/AllowAdmin/:toggleValue', controllers.Admin.AllowMultipleAdmin);
router.get('/ActiveUsers', controllers.Admin.ActiveUsers);
router.get('/', controllers.Admin.ActiveUsers);

module.exports = router;
