// db.js
const mongoose = require('mongoose');
require('dotenv').config(); // Make sure this is at the top
// const { createSuperAdmin } = require('../Controller/user');


const connectDB = async () => {
    try {
        // console.log(process.env.MONGO_URI);
        
        // Use MONGO_URI from .env
        await mongoose.connect(process.env.MONGO_URI,{});
        console.log('Connected to the database');
        // await createSuperAdmin();
        
    } catch (error) {
        console.error('Error connecting to the database', error);
        process.exit(1); // Exit process with failure
    }
};


module.exports = connectDB;
