const nodemailer = require("nodemailer");
require("dotenv").config();

const transporter = nodemailer.createTransport({
    service: 'gmail',
    auth: {
        user: process.env.EMAIL,
        pass: process.env.PASS,
    },
});

const mailOptions = {
    from: process.env.EMAIL,
    to: 'umar2001malik@gmail.com', // Change to your test recipient
    subject: 'Test Email',
    text: 'This is a test email.',
};

// transporter.sendMail(mailOptions, (error, info) => {
//     if (error) {
//         return console.log('Error sending email:', error);
//     }
//     console.log('Email sent:', info.response);
// }); 
const sendEmail = (mailOptions) => {
    return new Promise((resolve, reject) => {
        transporter.sendMail(mailOptions, (error, info) => {
            if (error) {
                console.error('Error sending email:', error);
                return reject(error); // Reject the promise with the error
            }
            console.log('Email sent:', info.response);
            resolve(info); // Resolve with the email sending info
        });
    });
};


module.exports = { sendEmail };









