// models/IndividualPlan.js
const mongoose = require('mongoose');

const individualPlanSchema = new mongoose.Schema({
    title: {
        type: String,
        required: true,
    },
    searchAllowed: {
        type: mongoose.Schema.Types.Mixed, // allows for both number and string values
    },
    allowedPersons: {
        type: Number,
        
    },
    allowedEmployees: {
        type: Number,
       
    },
  
    role: {
        type: String,
        required: true,
    },
    price: {
        type: Number,
        default: null,
    },
    
});

module.exports = mongoose.model('IndividualPlan', individualPlanSchema);
