// models/User.js
const mongoose = require('mongoose');

const userSchema = new mongoose.Schema({
    name: {
        type: String,
        required: false,
        
    },
    email: {
        type: String,
        required: true,
        unique: true,
    },
    password: {
        type: String,
        required: true,
    },
    credit: {
        type: Number,
        required: false,
        default: 0,
    },
    role: {
        type: String,
        required: false,
    },
    token: {
        type: String,
        required: false,

    },
    remainder: {
        type: String,
        required: false,
    },
    
    number: {
        type: Number,
        required: false,
        default: 0,
    },
    CompanyId: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'Company', // Reference the CompanyUser model
        required: false, // Set to true if a user must be linked to a CompanyUser
    },
    AdminId: {
        type: mongoose.Schema.Types.ObjectId,
        ref: 'User', 
        required: false, 
    },
    plan: {
        type: Number,
        required: false,
        default:0,
    },
    subscriptionValid: {
        type: Date,
    },
     
    promoCode: {
        type: Number, 
        required: false,
        default: 0,
    },
    sessionAllowed: {
        type:Number,
        default:1
    },
    imageUrl: {
        type: String
    }, 
       
    otp: {
        type: Number, 
        required: false,
        
    },
    markup:{
  type:Number,
  require:false
    },
    T_Version: {
        type: Number, 
        required: false,
        default: 1,
        
    },
    createdAt: {
        type: Date,
        default: Date.now,
    },
});

const User = mongoose.model('User', userSchema);
module.exports = User;
