const mongoose = require("mongoose");

const purchaseSchema = new mongoose.Schema({
  userId: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'User',
    required: true,
  },
  vehicle_type: {
    type: String,
    default: "",
  },
  Vin: {
    type: String,
    required: true,
    unique: true,
  },
  containerNumber: {
    type: String,
    default: "",
  },
  lotNumber: {
    type: String,
    default: "",
  },
  bid: {
    type: Number,
    default: 0,
  },
  auctionFees: {
    type: Number,
    default: 0,
  },
  shippingPort: {
    type: String,
    default: "",
  },
  transportStatus: {
    type: String,
    default: 'pending',
  },
  photoUrl: [
    {
      type: String,
    }
  ],
  status: {
    type: String,
    enum: ['pending', 'accepted', 'rejected', 'completed'],
    default: 'pending',
  },
  shipping: {
    cost: {
      type: Number,
      default: 0,
    },
    paid: {
      type: Number,
      default: 0,
    },
    Markup_shipping_cost: {
      type: Number,
      default: 0,
    },
    total_cost: {
      type: Number,
      default: 0,
    },
    status: {
      type: String,
      enum: ['dispatch', 'loaded', 'delivered'],
      default: 'dispatch',
    },
    arrival: {
      type: Date,
    },
  },
  purchase_payment: {
    due: {
      type: Number,
      default: 0,
    },
    paid: {
      type: Number,
      default: 0,
    },
    adjustment: {
      type: Number,
      default: 0,
    },
    base_purchase_cost: {
      type: Number,
      default: 0,
    }
  }
}, { timestamps: true });

const Purchase = mongoose.model("Purchase", purchaseSchema);
module.exports = Purchase;