const mongoose = require('mongoose');

// Define the schema for storing VIN, HTML content, and file paths for CSS/JS
const HtmlDataSchema = new mongoose.Schema({
    vin: {
        type: String,
        required: true,
        unique: true,
    },
    htmlContent: {
        type: String,
        required: true,
    },
    createdAt: {
        type: Date,
        default: Date.now,
        expires: 604800 // 7 days (in seconds)
    }
}, { timestamps: true });

const HtmlData = mongoose.model('HtmlData', HtmlDataSchema);
module.exports = HtmlData;
