const mongoose = require('mongoose');

// Define the UserHistory schema
const userHistorySchema = new mongoose.Schema({
    searchVin: {
        type: String,  
        required: true,  
    },
    date: {
        type: Date,  
        default: Date.now,  // Set default to current date
        expires: 2592000 // 30 days (in seconds)
    },
    user: {  // Reference to the User model
        type: mongoose.Schema.Types.ObjectId,  
        ref: 'User',  // Refers to the User model
        required: true,  // Ensure that each history entry has an associated user
    },
});

// Create the model from the schema
const UserHistory = mongoose.model('UserHistory', userHistorySchema);

module.exports = UserHistory;
