const mongoose = require('mongoose');

const userFavoriteSchema = new mongoose.Schema({
  user: {
    type: mongoose.Schema.Types.ObjectId,
    ref: 'User',
    required: true
  },
  
  carId: {
    type: String,
    required: true
  },
  carData: {
    type: mongoose.Schema.Types.Mixed,
    required: true
  },
  createdAt: {
    type: Date,
    default: Date.now
  }
});

// Compound index to ensure unique user-car pairs
userFavoriteSchema.index({ user: 1, carId: 1 }, { unique: true });

module.exports = mongoose.model('UserFavorite', userFavoriteSchema);