const mongoose = require('mongoose');

const vehicleSchema = new mongoose.Schema({
    id: { type: String, required: true },
    lot_id: { type: Number, required: true },
    site: { type: Number },
    base_site: { type: String },
    salvage_id: { type: Number },
    odometer: { type: Number },
    price_new: { type: Number },
    price_future: { type: Number },
    current_bid: { type: Number },
    auction_date: { type: Date },
    cost_priced: { type: Number },
    cost_repair: { type: Number },
    year: { type: Number },
    cylinders: { type: Number },
    state: { type: String },
    vehicle_type: { type: String },
    auction_type: { type: String },
    make: { type: String },
    model: { type: String },
    series: { type: String },
    damage_pr: { type: String },
    damage_sec: { type: String },
    keys: { type: String },
    odobrand: { type: String },
    fuel: { type: String },
    drive: { type: String },
    transmission: { type: String },
    color: { type: String },
    status: { type: String },
    title: { type: String },
    vin: { type: String, required: true},
    engine: { type: String },
    engine_size: { type: Number },
    location: { type: String },
    location_id: { type: Number },
    country: { type: String },
    document: { type: String },
    currency: { type: String },
    seller: { type: String },
    is_buynow: { type: Boolean },
    link_img_hd: { type: [String] },
    link_img_small: { type: [String] },
    is_offsite: { type: Boolean },
    link: { type: String },
    body_type: { type: String },
    seller_type: { type: String },
    vehicle_score: { type: Number },
    hash_data: { type: String },
    created_at: { type: Date, default: Date.now },
    updated_at: { type: Date, default: Date.now }
});

const CurrentBits = mongoose.model('CurrentBits', vehicleSchema);
module.exports = CurrentBits;
