// models/AddToCart.js
const mongoose = require('mongoose');

const addToCartSchema = new mongoose.Schema({
    lotId: {
        type: Number, // Changed from ObjectId to Number
        required: true
    },
    userId: {
        type: mongoose.Schema.Types.ObjectId,
        required: true,
        ref: 'User'
    },
    createdAt: {
        type: Date,
        default: Date.now
    }
});

const AddToCart = mongoose.model('AddToCart', addToCartSchema);
module.exports = AddToCart;
