// controllers/addToCartController.js
const model = require('../Model/index');



exports.addToCart = async (req, res) => {
    try {
        
        const {lotId } =req.body;
        const userId = req.user.id;
        

        if (!lotId || !userId) {
            return res.status(400).json({ message: 'lotId and userId are required' });
        }

        // Create a new cart item using Sequelize
        const cartItem = await model.AddToCart.create({
            lotId,
            userId
        });

        res.status(201).json({ message: 'Item added to cart successfully', cartItem });
    } catch (error) {
        res.status(500).json({ message: 'Server error', error: error.message });
    }
};


// Get all cart items for a user
// exports.getCartItems = async (req, res) => {
//     try {
//         const { userId } = req.params;

//         if (!userId) {
//             return res.status(400).json({ message: 'User ID is required' });
//         }

//         const cartItems = await AddToCart.find({ userId }).populate('lotId');
//         res.status(200).json(cartItems);
//     } catch (error) {
//         res.status(500).json({ message: 'Server error', error: error.message });
//     }
// };

// // Remove an item from the cart
// exports.removeFromCart = async (req, res) => {
//     try {
//         const { cartItemId } = req.params;

//         if (!cartItemId) {
//             return res.status(400).json({ message: 'Cart item ID is required' });
//         }

//         await AddToCart.findByIdAndDelete(cartItemId);
//         res.status(200).json({ message: 'Item removed from cart successfully' });
//     } catch (error) {
//         res.status(500).json({ message: 'Server error', error: error.message });
//     }
// };
